const express = require('express');
const cors = require('cors');

const app = express();
app.use(cors());

app.use(express.json({ limit: '50mb' }));
app.use(express.urlencoded({ limit: '50mb', extended: true }));

const port = process.env.PORT || 3000;


app.get('/', async (req, res) => {
    return res.status(200).json({ message: 'Conectado a la api html-pdf' });
});


app.post('/', async (req, res) => {
    const axios = require('axios');

    try {
        const texto = req.body.html || "";

        if (texto === "")
            return res.status(400).json({ error: "Ingrese HTML" });

        const apiUrl = 'http://192.3.245.177/html-pdf/pdf';
        const info = { html: texto };

        const response = await axios.post(apiUrl, info);
        const data = response.data;

        if (data.error != "" || data.base64 == "")
            return res.status(400).json({ error: "Error al generar PDF: " + data.error });

        return res.send({ error: data.error, base64: data.base64 });

    } catch (error) {
        console.error("Error al procesar la solicitud:", error);
        return res.status(500).json({ error: error.message });
    }
});

app.post('/local', async (req, res) => {
    let pdf = require("html-pdf");
    let html = req.body.html;

    if (!html) return res.send({ error: "ingrese html" });

    try {

        var options = {
            format: 'Letter',
            timeout: 30000
        }

        pdf.create(html, options).toBuffer(async function (err, buffer) {
            if (err) return res.send({ error: err.message, base64: "" });
            let base64 = await buffer.toString('base64');
            return res.send({ error: "", base64 });
        });

    } catch (err) {
        return res.send({ error: err.message });
    }
});


app.listen(port, () => {
    console.log(`Servidor escuchando en el puerto ${port}`);
});